var canvas = document.getElementById('canv');
var ctx = canvas.getContext("2d");

var LEFT  = "LEFT"
,   RIGHT = "RIGHT"
,   UP    = "UP"
,   DOWN  = "DOWN";


/*
UIから操作用のテストコード

document.body.onkeydown = function( evt ) {
  var keyTypes = {
    37: LEFT,
    38: UP,
    39: RIGHT,
    40: DOWN
  };

  if ( typeof keyTypes[ evt.keyCode ] != 'undefined' ) {
    move( keyTypes[ evt.keyCode ] );
  }
};
*/

var IMG_WIDTH = 100
,   IMG_HEIGHT = 88;

var current_x = 0
,   current_y = 0;

var seek = 20;

function move( keyType ) {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  switch ( keyType ) {
    case LEFT:
      if ( (current_x - seek) >= 0 ) current_x -= seek;
      break;
    case RIGHT:
      if ( (current_x + IMG_WIDTH + seek ) <= canvas.width ) current_x += seek;
      break;
    case UP:
      if ( (current_y - seek ) >= 0 ) current_y -= seek;
      break;
    case DOWN:
      if ( (current_y + IMG_HEIGHT + seek ) <= canvas.height ) current_y += seek;
      break;
  }

  renderImage( current_x, current_y );

}

// Initialize 
var img = new Image();
var socket;
function init() {
  socket = io.connect('');
  socket.on('move action receive', function (data) {
      move(data.keyType)
  });
  socket.on('initialize render', function(data){
    current_x = data.x;
    current_y = data.y;
    // create image
    img.src = '/images/fox2.png';
    img.onload = function() {
      renderImage( current_x, current_y);
    }
  });
}

function renderImage( x, y ) {
   ctx.drawImage(img, x, y, IMG_WIDTH, IMG_HEIGHT);
   socket.emit('moved target', {x : x, y : y});
}


init();