package com.example.web;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

import com.example.domain.Shoes;
import com.example.domain.User;
import com.example.service.LoginUser;

@Controller
@RequestMapping("limited")
public class EcsiteController {
	
	//トップ画面遷移(現在のログインユーザーデータもmodelに格納済み)
	@GetMapping("top")
	public String top(Model model, @AuthenticationPrincipal LoginUser userDetails) {
		User user = userDetails.getUser();
		model.addAttribute("user", user);
		return "index";
	}
	
	@GetMapping("list")
	public String list() {
		return "Hello world";
	}
	
	//画像登録用
//	@PostMapping("admin/management/shoes")
//	public String CreateShoes(@Validated,
//	        MultipartFile multipartFile) throws Exception {
//	 
//	    if (!multipartFile.isEmpty()) {
//	        try {
//	            // ファイル名をリネイム
//	            File oldFileName = new File(multipartFile.getOriginalFilename());
//	            File newFileName = new File(oldFileName + ".jpg");
//	            oldFileName.renameTo(newFileName);
//	 
//	            // 保存先を定義
//	            String uploadPath = "src/main/resources/static/upload/";
//	            byte[] bytes = multipartFile.getBytes();
//	 
//	            // 指定ファイルへ読み込みファイルを書き込み
//	            BufferedOutputStream stream = new BufferedOutputStream(
//	                    new FileOutputStream(new File(uploadPath + newFileName)));
//	            stream.write(bytes);
//	            stream.close();
//	 
//	            // 圧縮
//	            File input = new File(uploadPath + newFileName);
//	            BufferedImage image = ImageIO.read(input);
//	            OutputStream os = new FileOutputStream(input);
//	            Iterator<ImageWriter> writers = ImageIO
//	                    .getImageWritersByFormatName("jpg");
//	            ImageWriter writer = (ImageWriter) writers.next();
//	            ImageOutputStream ios = ImageIO.createImageOutputStream(os);
//	            writer.setOutput(ios);
//	            ImageWriteParam param = new JPEGImageWriteParam(null);
//	            param.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
//	            param.setCompressionQuality(0.30f);
//	            writer.write(null, new IIOImage(image, null, null), param);
//	            os.close();
//	            ios.close();
//	            writer.dispose();
//	 
//	            // DBに写真の名前を格納する
//	            service.updatePhoto(account.getUsername(), newFileName.toString());
//	 
//	        } catch (Exception e) {
//	            System.out.println(e);
//	        }
//	    }
//	    return "forward:/top";
//	}
}
