package com.example.repository;

import java.sql.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.example.domain.SalesLog;

@Repository
public interface SalesLogRepository extends JpaRepository<SalesLog, Integer>{
	@Query(value = "SELECT id,user_id, shoes_id, quantity, SUM(price) AS price, created   FROM sales_logs AS sl  WHERE sl.user_id = ?1  GROUP BY sl.created",
			  nativeQuery = true)
	public List <SalesLog> history(Integer id);
	@Query(value = "SELECT id, user_id, shoes_id, quantity, price, created FROM sales_logs AS sl WHERE sl.created = ?1 && sl.user_id = ?2",
			nativeQuery = true)
	public List <SalesLog> historyDetails(Date created, Integer id);
	@Query(value = "SELECT id, user_id, shoes_id, quantity, price, created FROM sales_logs AS sl WHERE sl.price >= ?1 && sl.price <= ?2 && sl.user_id = ?3",
			nativeQuery = true)
	public List <SalesLog> searchPrice(Integer lowPrice, Integer highPrice, Integer id);
}
