package com.example.api;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;

import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.example.domain.ItemData;
import com.example.domain.Items;
import com.example.domain.User;
import com.example.service.ItemsService;
import com.example.service.LoginUser;
import com.example.service.LoginUserDetailsService;
import com.example.service.SalesLogService;

@RestController
@RequestMapping("limited")
@SessionAttributes(names ="itemData")
public class EcsiteRestController {
	@Autowired
	LoginUserDetailsService loginUserDetailsService;
	@Autowired
	ItemsService itemsService;
	@Autowired
	HttpSession session;
	@Autowired
	SalesLogService salesLogService;
	int totalPrice;
	
	@PostMapping("signUp")
	public User createUser(@RequestBody User user) {
		user.setRoles("USER");
		LocalDate localDate =  LocalDate.now();
		Date nowDate = Date.valueOf(localDate);
		user.setCreatedAt(nowDate);
		user.setUpdatedAt(nowDate);
		user.setPassword(new Pbkdf2PasswordEncoder().encode(user.getPassword()));
		loginUserDetailsService.create(user);
		return user;
	}
	
	@PostMapping("inputCart")
	public void inputCart(@RequestBody ItemData data, Model model) {
		if(session.getAttribute("cart") == null){
			LinkedHashMap<String, Items> cart = new LinkedHashMap<String, Items>();
			String id = data.getShoesId().toString(); 
			cart.put(id , itemsService.findOne(data.getShoesId(),data.getQuantity()));
			System.out.println(cart);
			session.setAttribute("cart", cart);
			session.setAttribute("cartValue", data.getQuantity());
		}else{
			LinkedHashMap<String, Items> cart = new LinkedHashMap<String, Items>();
			String id = data.getShoesId().toString();
			cart = (LinkedHashMap<String, Items>) session.getAttribute("cart");
			cart.put(id, itemsService.findOne(data.getShoesId(),data.getQuantity()));
			session.setAttribute("cart", cart);
			int nowQuantity =  (int) session.getAttribute("cartValue");
			session.setAttribute("cartValue", nowQuantity + data.getQuantity());
		}
	}
	
	@GetMapping("buy")
	public void buy(@AuthenticationPrincipal LoginUser userDetails, LinkedHashMap<String, Items> items, ArrayList <Items> cart){
		items = (LinkedHashMap<String, Items>) session.getAttribute("cart");
		items.forEach((key, value) -> {
			cart.add(value);
		});
		//User user = userDetails.getUser();
		//Integer userId = user.getId();
		salesLogService.update(1, cart);
		session.removeAttribute("cart");
	}
}