package com.example.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Service;

import com.example.domain.Items;
import com.example.domain.SalesLog;
import com.example.repository.SalesLogRepository;

@Service
public class SalesLogService {
	@Autowired
	SalesLogRepository salesLogRepository;
	
	public List<SalesLog> findAll(){
		return salesLogRepository.findAll();
	}
	
	public SalesLog findOne(Integer id){
		return salesLogRepository.findOne(id);
	}
	
	public SalesLog create(SalesLog salesLog){
		return salesLogRepository.save(salesLog);
	}
	
	public void update(Integer userId, ArrayList <Items> cart){
		int count = 0;
		java.util.Date d1 = new java.util.Date();
		//d1をSQL.DATE型に変換してtodayに代入
		java.sql.Date today = new java.sql.Date(d1.getTime());
		System.out.println(cart.size());
		for(int i = 0; i < cart.size(); i++){
			SalesLog salesLog = new SalesLog();
			salesLog.setUserId(userId);
			salesLog.setShoesId((cart.get(i)).getShoesId());
			salesLog.setPrice((cart.get(i)).getPrice());
			salesLog.setCreated(today);
			salesLogRepository.save(salesLog);
			count++;
		}
		System.out.println(count);
	}
	
	public List<SalesLog> history(Integer id) {
		return salesLogRepository.history(id);
	}
	
	public List <SalesLog> historyDetails(Date created, Integer id) {
		return salesLogRepository.historyDetails(created, id);
	}
}
