package com.example.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.domain.Wallets;
import com.example.repository.WalletsRepository;

//ユーザウォレットのサービス
@Service
public class WalletsService {
	@Autowired
	WalletsRepository walletsRepository;
	
	public List<Wallets> findAll(){
		return walletsRepository.findAll();
	}
	
	public Wallets findOne(Integer id){
		return walletsRepository.findByUserId(id);
	}
	
	public Wallets create(Wallets wallet){
		return walletsRepository.save(wallet);
	}
	
	public Wallets update(Wallets wallet){
		return walletsRepository.save(wallet);
	}
	
	//チャージ処理
	public Wallets charge(Integer id, Integer amount){
		//対象の財布情報を取得
		Wallets wallet = new Wallets();
		wallet = this.findOne(id);
		wallet.setAmount(wallet.getAmount() + amount);
		return walletsRepository.save(wallet); 
	}
	
	//支払い処理
	public Wallets pay(Integer id, Integer amount){
		//対象の財布情報を取得
		Wallets wallet = new Wallets();
		wallet = this.findOne(id);
		wallet.setAmount(wallet.getAmount() - amount);
		return walletsRepository.save(wallet); 
	}
}
