package com.example.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.domain.Shoes;
import com.example.repository.ShoesRepository;

//靴用サービス
@Service
public class ShoesService {
	@Autowired
	ShoesRepository shoesRepository;
	
	public List<Shoes> findAll(){
//		List<Shoes> list = shoesRepository. findAll();
//		//並べ替え処理
//		Collections.sort(list, Collections.reverseOrder());
//		//並べ替えたものを返す。
//		return list;
		return shoesRepository.findAll();
	}
	
	public Shoes findOne(Integer id){
		return shoesRepository.findOne(id);
	}
	
	public Shoes create(Shoes shoes){
		return shoesRepository.save(shoes);
	}
	
	public Shoes update(Shoes shoes){
		return shoesRepository.save(shoes);
	}
	
	public void delete(Integer id){
		shoesRepository.delete(id);
	}
	
	//ユニーク機能、一般商品と限定商品の出し分け
	//一般商品
	public List<Shoes> findAllGeneralShoes() {
	    return shoesRepository.findAllByStatus(0);
	}
	
	//限定商品
	public List<Shoes> findAllLimitedShoes() {
	    return shoesRepository.findAllByStatus(1);
	}
	
	//管理画面、重複商品のバリデーション
	public Shoes findOneAddStock(String name, Integer size) {
		return shoesRepository.findOneAddStock(name, size);
	};
}
