package com.example.service;

import java.util.Collection;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

import com.example.domain.User;


//ユーザーの認証・認可にかかわるクラス
public class LoginUser extends org.springframework.security.core.userdetails.User{
	
	private static final long serialVersionUID = 1L;
	private final User user;
	
	public LoginUser(User user){
		super(user.getEmail(), user.getPassword(), getAuthorities(user.getRoles()));
		this.user = user;
	}
	
	public User getUser() {
		return user;
	}
	
	//ログイン権限、文字列変更
	private static Collection<GrantedAuthority> getAuthorities(String role) {
		if (role.equals("ADMIN")) {
			return AuthorityUtils.createAuthorityList("ROLE_ADMIN", "ROLE_GENERAL");
		} else {
			return AuthorityUtils.createAuthorityList("ROLE_GENERAL");
		}
	}
}
