package com.example.web;

import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import com.example.domain.User;
import com.example.service.LoginUser;

@Controller
@RequestMapping("limited")
public class EcsiteController {
	
	//トップ画面遷移(現在のログインユーザーデータもmodelに格納済み)
	@GetMapping("top")
	public String top(Model model, @AuthenticationPrincipal LoginUser userDetails) {
		User user = userDetails.getUser();
		model.addAttribute("user", user);
		return "index";
	}
	
	@GetMapping("list")
	public String list() {
		return "Hello world";
	}
}
