package com.example.repository;

import java.sql.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.example.domain.SalesLog;

@Repository
public interface SalesLogRepository extends JpaRepository<SalesLog, Integer>{
	@Query(value = "SELECT id,user_id, shoes_id, SUM(price) AS price, created   FROM sales_logs AS sl  WHERE sl.user_id = ?1  GROUP BY sl.created",
			  nativeQuery = true)
	public List <SalesLog> history(Integer id);
	@Query(value = "SELECT id, user_id, shoes_id, price, created FROM sales_logs AS sl WHERE sl.created = ?1",
			nativeQuery = true)
	public List <SalesLog> historyShoes(Date created);
}
