package com.example.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.domain.User;
import com.example.service.LoginUser;
import com.example.service.LoginUserDetailsService;


@RestController
@RequestMapping("limited/admin/management")
public class ManagementRestController {
	@Autowired
	LoginUserDetailsService loginUserDetailsService;
	
	//user権限変更
	@PostMapping(path = "{id}/changeRole")
	User changeRoles(@PathVariable Integer id, @AuthenticationPrincipal LoginUser loginUser, @RequestBody User userdata){
		User user = loginUserDetailsService.findOne(id);
		//String role = userdata.getRoles();
		if(userdata.getRoles().equals("ADMIN")){
			user.setRoles("USER");
		}else{
			user.setRoles("ADMIN");
		}
		loginUserDetailsService.create(user);
		return user;
	}
}
