package com.example.web;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import com.example.domain.Shoes;
import com.example.domain.User;
import com.example.service.LoginUser;
import com.example.service.ShoesService;

@Controller
@RequestMapping("limited")
public class EcsiteController {
	@Autowired
	ShoesService shoesService;
	
	//写真の表示用メソッド
	public String photoView(String Photo) {
		// 画像を検索してbyteとしてViewへ受け渡す
		String uploadPath = "src/main/resources/static/upload/" + Photo;
		// 画像データストリームを取得する
		try (FileInputStream fis = new FileInputStream(uploadPath);) {
		StringBuffer data = new StringBuffer();
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		byte[] buffer = new byte[1024];
		// バイト配列に変換
		while (true) {
		int len = fis.read(buffer);
		if (len < 0) {
		        break;
		        }
		        os.write(buffer, 0, len);
		}
		// 画像データをbaseにエンコード
		String base64 = new String(
		org.apache.tomcat.util.codec.binary.Base64.encodeBase64(os.toByteArray()),"ASCII");
		// 画像タイプはJPEG
		// Viewへの受け渡し。
		            data.append("data:image/jpeg;base64,");
		            data.append(base64);
		 
		return data.toString();
		 
		} catch (Exception e) {     e.printStackTrace();
		return null;
		}
	}
	
	
	//トップ画面遷移(現在のログインユーザーデータもmodelに格納済み)
	@GetMapping("top")
	public String top(Model model, @AuthenticationPrincipal LoginUser userDetails) {
		User user = userDetails.getUser();
		model.addAttribute("user", user);
		//遷移先 設定済み
		return "index";
	}
	
	
	//一覧画面遷移(靴の情報と画像を一緒にmodelにあげることが出来ない為、分けてある)
	@GetMapping("list")
	public String list(Model model) {
		//靴の情報をすべて取得
		List<Shoes> shoes = shoesService.findAll();
		//靴の情報を一括で取得するmodel(Idでの降順表示設定済み)
		model.addAttribute("shoes", shoes);
		//靴を表示するための処理を全画像にかける
		List <String> shoesPhoto = new ArrayList<String> ();
		for(int i = 0; i < shoes.size(); i++) {
			shoesPhoto.add((shoes.get(i)).getPhoto());
		}
		//靴の処理した画像を一括で取得する
		model.addAttribute("shoesPhoto", shoesPhoto);
		//遷移先 未設定
		return "Hello world";
	}
}
