package com.example.domain;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

//ログイン用のエンティティークラス
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name="users")
@ToString(exclude = { "email", "password" })
public class User {
	@GeneratedValue
	private int id;
	@Column(nullable = false)
	private String name;
	@Column(nullable = false)
	private String postalCode;
	@Column(nullable = false)
	private String address;
	@Column(nullable = false)
	private String phoneNumber;
	@Id
	@Column(nullable = false)
	private String email;
	@Column(nullable = false)
	private String password;
	@Column(nullable = false)
	private String roles;
	@Column(nullable = false)
	private Date createdAt;
	@Column(nullable = false)
	private Date updatedAt;
}
