package com.example.api;

import java.sql.Date;
import java.time.LocalDate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.example.domain.SessionData;
import com.example.domain.User;
import com.example.service.LoginUserDetailsService;

@RestController
@RequestMapping("limited")
@SessionAttributes(value = {"sessionData"})
public class EcsiteRestController {
	@Autowired
	LoginUserDetailsService loginUserDetailsService;
	
	@ModelAttribute(value = "sessionData") // (1)
	public SessionData sessionData() {
	    return new SessionData();
	}
	
	@PostMapping("signUp")
	public User createUser(@RequestBody User user) {
		user.setRoles("USER");
		LocalDate localDate =  LocalDate.now();
		Date nowDate = Date.valueOf(localDate);
		user.setCreatedAt(nowDate);
		user.setUpdatedAt(nowDate);
		user.setPassword(new Pbkdf2PasswordEncoder().encode(user.getPassword()));
		loginUserDetailsService.create(user);
		return user;
	}
	
	@PostMapping("inputCart")
	public void inputCart(@RequestParam SessionData data, Model model) {
		data.setSesionData(data.getShoesId(), data.getQuantity());
		model.addAttribute("cart", data.getCart()); 
	}
	
}