package com.example.api;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.example.domain.ItemData;
import com.example.domain.Items;
import com.example.domain.User;
import com.example.service.ItemsService;
import com.example.service.LoginUserDetailsService;

@RestController
@RequestMapping("limited")
@SessionAttributes(names ="itemData")
public class EcsiteRestController {
	@Autowired
	LoginUserDetailsService loginUserDetailsService;
	@Autowired
	ItemsService itemsService;
	@Autowired
	HttpSession session;
	
	@PostMapping("signUp")
	public User createUser(@RequestBody User user) {
		user.setRoles("USER");
		LocalDate localDate =  LocalDate.now();
		Date nowDate = Date.valueOf(localDate);
		user.setCreatedAt(nowDate);
		user.setUpdatedAt(nowDate);
		user.setPassword(new Pbkdf2PasswordEncoder().encode(user.getPassword()));
		loginUserDetailsService.create(user);
		return user;
	}
	
	@PostMapping("inputCart")
	public void inputCart(@RequestBody ItemData data, HashMap<String, Items> cart) {
		if(session.getAttribute("cart") == null){
			cart.put((data.getShoesId()).toString(), itemsService.findOne(data.getShoesId(),data.getQuantity()));
			session.setAttribute("cart", cart);
		}else{
			cart = (HashMap<String, Items>) session.getAttribute("cart");
			cart.put((data.getShoesId()).toString(), itemsService.findOne(data.getShoesId(),data.getQuantity()));
			session.setAttribute("cart", cart);
		}
	}
	
}