package com.example;

import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;


@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter{
	
	@Override
	public void configure(WebSecurity web) throws Exception{
		web.debug(false).ignoring().antMatchers("/images/**", "/js/**", "/css/**", "/fonts/**");
	}
	
	@Override
	protected void configure(HttpSecurity http) throws Exception {
		http
			.authorizeRequests()
				.mvcMatchers("/limited/login","/limited/signUp").permitAll() //ログイン前でもアクセス可能なＵＲＬの指定
				.mvcMatchers("/limited/admin/**").hasRole("ADMIN")//ADMIN権限のユーザーのみアクセスできるURLの指定
				.anyRequest().authenticated()//ログイン前は他のアドレスにログインできないよう指定s
			.and()
			.formLogin()
				.loginProcessingUrl("/login") //ログイン処理でpostするURL
				.loginPage("/limited/login") //ログインページのURL
				.defaultSuccessUrl("/limited/top", true) //ログイン成功時のURL
				.usernameParameter("email").passwordParameter("password") //ログインのパラメーター指定
			.and()
			.logout()
				.invalidateHttpSession(true)
				.deleteCookies("JSESSIONID") //ログアウト時キャッシュを削除する処理
				.logoutSuccessUrl("/limited/login"); //ログアウト後に表示するURL
	}
	
	@Bean //パスワードのハッシュか
	PasswordEncoder passwordEncoder(){
		return new Pbkdf2PasswordEncoder();
	}
}
