package com.example.api;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.example.domain.Cart;
import com.example.domain.CartData;
import com.example.domain.User;
import com.example.service.LoginUserDetailsService;

@RestController
@RequestMapping("limited")
//@SessionAttributes(names ="cart")
public class EcsiteRestController {
	@Autowired
	LoginUserDetailsService loginUserDetailsService;
	
	@ModelAttribute("cart") // (1)
	public ArrayList<Cart> setSessionData(ArrayList<Cart> arrayList) {
	    return arrayList;
	}
	
	@PostMapping("signUp")
	public User createUser(@RequestBody User user) {
		user.setRoles("USER");
		LocalDate localDate =  LocalDate.now();
		Date nowDate = Date.valueOf(localDate);
		user.setCreatedAt(nowDate);
		user.setUpdatedAt(nowDate);
		user.setPassword(new Pbkdf2PasswordEncoder().encode(user.getPassword()));
		loginUserDetailsService.create(user);
		return user;
	}
	
	@PostMapping("inputCart")
	public void inputCart(@RequestBody CartData data, Model model) {
		Cart cart = new Cart();
		cart.setCart(data.getShoesId(), data.getQuantity());
		//return cart.getCart();
	}
	
}